#pragma rtGlobals=1		// Use modern global access method.
//Doug Kohls

Menu "MT-DMA"
		"Metler Toledo Loader", Load_MT_DMA()
end
Macro Load_MT_DMA()
	String sampleID, tempName,timeName,freqName,forceName,displName,phaseName,f0name,x0name,clamptempName,stomodName,lossmodName,complexName,tandName,stocompName,losscompName,compcompName
	
	
	SetDataFolder root:
	if (DataFolderExists("DMA")!=1)
		newdatafolder DMA
	endif
	SetDataFolder DMA

	newdatafolder/o loadFolder
	SetDataFolder loadFolder
	LoadWave /A=wave/D/G/K=1/V={"\t, "," $",0,0}/L={0,1,0,0,0}/N=DMA
	killwaves DMA0
	sampleID=S_filename
	sampleID=sampleID[0,strlen(sampleID)-5]
	tempName="Temperature_iC"
	timeName="Time_min"
	freqName="Frequency_Hz"
	forceName="Force"
	displName="Amplitude_m"
	phaseName="Phase_rad"
	f0name="StaticForce_N"
	x0name="StaticDisplacement_m"
	clamptempName="ClampTemperature_C"
	stomodName="StorageModulus_MPa"
	lossmodName="LossModulus_MPa"
	complexName="ComplexModulus_MPa"
	tandName="TanDelta"
	stocompName="StorageCompliance_MPa"
	losscompName="LossCompliance_MPa"
	compcompName="ComplexCompliance_MPa"
	
	if (DataFolderExists(sampleID)!=1)
		killdatafolder/Z $sampleID
		renamedatafolder root:DMA:loadFolder, $sampleID
	
	endif
	Rename DMA1, $tempName
	
	//time converted from seconds to minutes
	DMA2/=60
	Rename DMA2, $timename
	Rename DMA3,$freqName
	Rename DMA4,$forceName
	Rename DMA5,$displName
	Rename DMA6,$phaseName
	Rename DMA7,$f0name
	Rename DMA8,$x0name
	Rename DMA9,$clamptempName
	Rename DMA10,$stomodName
	Rename DMA11,$lossmodName
	Rename DMA12,$complexName
	Rename DMA13,$tandName
	Rename DMA14,$stocompName
	Rename DMA15,$losscompName
	Rename DMA16,$compcompName

end
